<?php
/**
 * Sales Orders Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Sales_orders extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Sales_orders_model');
		$this->load->model('Configuration_model');
		$this->load->model('Customers_model');
		$this->load->model('Items_model');
		$this->load->model('Logs_model');
		$this->load->model('Wholesale_prices_model');
		$this->load->model('Special_prices_model');
		$this->load->model('Ptsreqs_model');
		$this->load->model('Log_points_model');
		$this->load->model('Users_model');
		$this->load->model('Ppn_model');
		$this->load->model('Group_prices_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
 	{	
		$data['content_title'] = 'Penjualan';
		
		if(check_roles('1')){
			$this->twiggy_display('adm/sales_orders/index', $data);
		}else{
			redirect("Error");
		}
	}
	 
	public function get_data_header()
	{	
		$data = [];
		// $order = "is_hold DESC";
		$order = "is_hold DESC, sales_order_header_date DESC, sales_order_header_number DESC";
		$get_data = $this->Sales_orders_model->salesorder_header('', $order)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{	
				$is_hold = ($get_row->is_hold == 0 ? '<i class="fas fa-circle text-success"></i>' : '<i class="fas fa-circle text-warning"></i>');

				$data[] = array(
					'no'          => $no,
					'id'          => $get_row->sales_order_header_id,
					'number'      => $get_row->sales_order_header_number,
					'date'        => indonesian_date($get_row->sales_order_header_date),
					'date_paid'   => indonesian_date($get_row->printed_date),
					'customer'    => $get_row->customer_name,
					'grand_total' => number_format($get_row->sales_order_header_grand_total),
					'description' => $get_row->sales_order_header_description,
					'is_hold'     => $is_hold,
				);
				$no++;
			}
		}

		$response = [
            'data'         => $data,
            'recordsTotal' => count($data)
        ];

        output_json($response);
	}

	public function get_payment_term()
	{
		$customer         = $this->input->post('customer');
		$sales_order_date = change_format_date($this->input->post('sales_order_date'));

		$where        = array('customer_id' => $customer);
		$payment_term = $this->Customers_model->get_data($where)->row()->customer_payment_term;
		$payment_due  = date("Y-m-d", strtotime('+' ."$payment_term". ' days', strtotime($sales_order_date)));
		
		$response = [
            'payment_term' => $payment_term,
            'payment_due'  => change_format_date($payment_due, 'd/m/Y')
		];
		
		echo json_encode($response);
	}

	public function get_payment_term_by_days()
	{
		$payment_term     = $this->input->post('payment_term');
		$sales_order_date = change_format_date($this->input->post('sales_order_date'));

		$payment_due  = date("Y-m-d", strtotime('+' ."$payment_term". ' days', strtotime($sales_order_date)));
		
		$response = [
            'payment_due'  => change_format_date($payment_due, 'd/m/Y')
		];
		
		echo json_encode($response);
	}

	public function get_wholesale_price()
	{
		$customer       = $this->input->post('customer');
		$item           = $this->input->post('item');
		$quantity_large = $this->input->post('quantity_large');

		$where_special_price    = array('a.customer_id' => $customer, 'a.item_id' => $item);
		$get_data_special_price = $this->Special_prices_model->get_data($where_special_price)->result();

		$group_customer_id    = $this->Customers_model->get_data(array('customer_id' => $customer))->row()->group_customer_id;
		$where_group_price    = array('a.group_customer_id' => $group_customer_id, 'a.item_id' => $item, 'a.price !=' => 0);
		$get_data_group_price = $this->Group_prices_model->get_data_group_price($where_group_price)->row();

		// echo json_encode($get_data_group_price);
		// die();
		$price = 0;
		if(!empty($get_data_group_price)){
			return false;
		}elseif(!empty($get_data_special_price)){
			return false;
		}else{
			$get_wholesale_price = $this->Wholesale_prices_model->get_data_range($item, $quantity_large)->row_array();
			if(!empty($get_wholesale_price)){
				$price = $get_wholesale_price['price'];
			}else{
				$where_last_price    = array('item_id' => $item);
				$get_data_last_price = $this->Items_model->get_data($where_last_price)->row_array();
				$price               = $get_data_last_price['last_selling_price_large_unit'];
			}
			echo json_encode(number_format($price));
		}
	}

 	public function edit($id = 'new')
	{
		$title = "Tambah Penjualan";
		$header_data = array(null);

		$ppn_data    = $this->Ppn_model->get_data(array('is_active' => '1'))->row();
		$ppn_amount  = (empty($ppn_data) ? 0 : to_decimal($ppn_data->amount));

		$prefix  = "TX";
		$datenow = date('Ym');
		$number_generator = $this->Sales_orders_model->salesorder_autonumber();
		$autonumber = $prefix.$datenow.$number_generator;

		$date_text       = date_now();
		$paid_total      = 0;
		$change_total    = 0;
		$remaining_total = 0;

	    if($id != 'new')
	    {
			$title           = "Edit Penjualan";
			$where           = array('sales_order_header_id' => $id);
			$header_data     = $this->Sales_orders_model->salesorder_header($where)->row_array();
			$autonumber      = $header_data['sales_order_header_number'];
			$date_text       = $header_data['sales_order_header_date'];
			$paid_total      = number_format($header_data['sales_order_header_paid_total']);
			$change_total    = number_format($header_data['sales_order_header_change_total']);
			$remaining_total = number_format($header_data['sales_order_header_remaining_total']);
		}

		$data['id']            = $id;
		$data['content_title'] = $title;
		$data['header_data']   = $header_data;
		$data['customer_data'] = $this->Customers_model->get_data()->result();

		
		$data['autonumber']      = $autonumber;
		$data['date_text']       = $date_text;
		$data['paid_total']      = $paid_total;
		$data['change_total']    = $change_total;
		$data['remaining_total'] = $remaining_total;
		$data['ppn_amount']      = $ppn_amount;

		if(check_roles('1')){
			$this->twiggy_display('adm/sales_orders/edit', $data);
		}else{
			redirect("Error");
		}
	}

	public function get_data_ppn()
	{
		$ppn_data    = $this->Ppn_model->get_data(array('is_active' => '1'))->row();
		$ppn_amount  = (empty($ppn_data) ? 0 : $ppn_data->amount);

		echo json_encode(to_decimal($ppn_amount));
	}

	public function get_data_detail()
	{	
		$id    = $this->input->post("id");
		$where = array('sales_order_detail_header_id' => $id);
		// $order = array('item_name' => 'asc');

		$data = [];
		$get_data = $this->Sales_orders_model->salesorder_detail($where)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if(count($get_data) > 0)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{

				$total_stock     = 0;
				$where_stock     = array('log_item_id' => $get_row->item_id);
				$get_data_stock  = $this->Logs_model->get_data_last($where_stock)->row_array();
				if($get_data_stock){
					$total_stock = $get_data_stock['log_total_stock'];
				}

				$ppn_status_color = "";
				if($get_row->sales_order_detail_ppn_status == '1'){
					$ppn_status_color = "";
				}elseif($get_row->sales_order_detail_ppn_status == '2'){
					$ppn_status_color = "bg-success";
				}else{
					$ppn_status_color = "bg-warning";
				}

				$total_stock_stored = ($total_stock + (($get_row->sales_order_detail_large_unit_quantity * $get_row->large_unit_contain) +
										($get_row->sales_order_detail_medium_unit_quantity * $get_row->medium_unit_contain) +
										($get_row->sales_order_detail_small_unit_quantity * $get_row->small_unit_contain)));
				$data[] = array(
					'no'                 => $no,
					'detail_id'          => $get_row->sales_order_detail_id,
					'detail_header_id'   => $get_row->sales_order_detail_header_id,
					'id'                 => $get_row->sales_order_detail_item_id,
					'name'               => $get_row->sales_order_detail_item_name,
					'lg_unit'            => $get_row->sales_order_detail_large_unit,
					'lg_unit_cnt'        => to_decimal($get_row->large_unit_contain),
					'lg_unit_qty'        => to_decimal($get_row->sales_order_detail_large_unit_quantity),
					'lg_unit_prc'        => number_format($get_row->sales_order_detail_large_unit_price),
					'result_large'       => $get_row->sales_order_detail_result_large,
					'md_unit'            => $get_row->sales_order_detail_medium_unit,
					'md_unit_cnt'        => to_decimal($get_row->medium_unit_contain),
					'md_unit_qty'        => to_decimal($get_row->sales_order_detail_medium_unit_quantity),
					'md_unit_prc'        => number_format($get_row->sales_order_detail_medium_unit_price),
					'result_medium'      => $get_row->sales_order_detail_result_medium,
					'sm_unit'            => $get_row->sales_order_detail_small_unit,
					'sm_unit_cnt'        => to_decimal($get_row->small_unit_contain),
					'sm_unit_qty'        => to_decimal($get_row->sales_order_detail_small_unit_quantity),
					'sm_unit_prc'        => number_format($get_row->sales_order_detail_small_unit_price),
					'result_small'       => $get_row->sales_order_detail_result_small,
					'ppn_status'         => $get_row->sales_order_detail_ppn_status,
					'ppn_status_color'   => $ppn_status_color,
					'total'              => number_format($get_row->sales_order_detail_total),
					'ppn_total'          => to_decimal($get_row->sales_order_detail_ppn_total),
					'total_stock'        => to_decimal($total_stock),
					'total_stock_stored' => to_decimal($total_stock_stored),
				);
				$no++;
			}
		}else{
			$where_header   = array('sales_order_header_id' => $id);
			$header         = $this->Sales_orders_model->salesorder_header($where_header)->row_array();
			$tax_percentage = $header['ppn_amount'];

			$where_restore = array('log_type' => 'SELL', 'log_transaction_id' => $id);
			$restore       = $this->Logs_model->get_data($where_restore)->result();

			$no = 1;
			foreach($restore as $get_row)
			{
				
				$total_stock     = 0;
				$where_stock     = array('log_item_id' => $get_row->log_item_id);
				$get_data_stock  = $this->Logs_model->get_data_last($where_stock)->row_array();
				if($get_data_stock){
					$total_stock = $get_data_stock['log_total_stock'];
				}

				$ppn_status_color = "";
				if($get_row->ppn_status == '1'){
					$ppn_status_color = "";
				}elseif($get_row->ppn_status == '2'){
					$ppn_status_color = "bg-success";
				}else{
					$ppn_status_color = "bg-warning";
				}

				$total_stock_stored = ($total_stock + ((abs($get_row->log_large_unit_quantity) * $get_row->log_large_unit_contain) +
										(abs($get_row->log_medium_unit_quantity) * $get_row->log_medium_unit_contain) +
										(abs($get_row->log_small_unit_quantity) * $get_row->log_small_unit_contain)));

				$res_lg = abs($get_row->log_large_unit_quantity) * $get_row->log_large_unit_selling_price;
				$res_md = abs($get_row->log_medium_unit_quantity) * $get_row->log_medium_unit_selling_price;
				$res_sm = abs($get_row->log_small_unit_quantity) * $get_row->log_small_unit_selling_price;

				$res_total = $res_lg + $res_md + $res_sm;

				$grand_total = $res_total;
				$ppn_total = 0;
				
				if($get_row->ppn_status == 2){
					$grand_total = $res_total + ($res_total * ($tax_percentage/100));
					$ppn_total = ($res_total * ($tax_percentage/100));
				}

				$data[] = array(
					'no'                 => $no,
					'detail_id'          => $get_row->log_id,
					'detail_header_id'   => $get_row->log_transaction_id,
					'id'                 => $get_row->log_item_id,
					'name'               => $get_row->item_name,
					'lg_unit'            => $get_row->log_large_unit,
					'lg_unit_cnt'        => to_decimal($get_row->log_large_unit_contain),
					'lg_unit_qty'        => to_decimal(abs($get_row->log_large_unit_quantity)),
					'lg_unit_prc'        => number_format($get_row->log_large_unit_selling_price),

					'result_large'       => $res_lg,

					'md_unit'            => $get_row->log_medium_unit,
					'md_unit_cnt'        => to_decimal($get_row->log_medium_unit_contain),
					'md_unit_qty'        => to_decimal(abs($get_row->log_medium_unit_quantity)),
					'md_unit_prc'        => number_format($get_row->log_medium_unit_selling_price),

					'result_medium'      => $res_md,

					'sm_unit'            => $get_row->log_small_unit,
					'sm_unit_cnt'        => to_decimal($get_row->log_small_unit_contain),
					'sm_unit_qty'        => to_decimal(abs($get_row->log_small_unit_quantity)),
					'sm_unit_prc'        => number_format($get_row->log_small_unit_selling_price),

					'result_small'       => $res_sm,

					'ppn_status'         => $get_row->ppn_status,
					'ppn_status_color'   => $ppn_status_color,

					'total'              => number_format($grand_total),

					'ppn_total'          => to_decimal($ppn_total),

					'total_stock'        => to_decimal($total_stock),
					'total_stock_stored' => to_decimal($total_stock_stored),
				);
				$no++;
			}

		}

		output_json($data);
	}

	public function get_data_detail2()
	{	
		$id    = $this->input->post("id");
		$where = array('sales_order_detail_header_id' => $id);
		// $order = array('item_name' => 'asc');

		$data = [];
		$get_data = $this->Sales_orders_model->salesorder_detail_ori($where)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
			$no = 1;
			foreach($get_data as $get_row)
			{

				$total_stock     = 0;
				$where_stock     = array('log_item_id' => $get_row->item_id);
				$get_data_stock  = $this->Logs_model->get_data_last($where_stock)->row_array();
				if($get_data_stock){
					$total_stock = $get_data_stock['log_total_stock'];
				}

				$ppn_status_color = "";
				if($get_row->sales_order_detail_ppn_status == '1'){
					$ppn_status_color = "";
				}elseif($get_row->sales_order_detail_ppn_status == '2'){
					$ppn_status_color = "bg-success";
				}else{
					$ppn_status_color = "bg-warning";
				}

				$total_stock_stored = ($total_stock + (($get_row->sales_order_detail_large_unit_quantity * $get_row->large_unit_contain) +
										($get_row->sales_order_detail_medium_unit_quantity * $get_row->medium_unit_contain) +
										($get_row->sales_order_detail_small_unit_quantity * $get_row->small_unit_contain)));
				$data[] = array(
					'no'                 => $no,
					'detail_id'          => $get_row->sales_order_detail_id,
					'detail_header_id'   => $get_row->sales_order_detail_header_id,
					'id'                 => $get_row->sales_order_detail_item_id,
					'name'               => $get_row->sales_order_detail_item_name,
					'lg_unit'            => $get_row->sales_order_detail_large_unit,
					'lg_unit_cnt'        => to_decimal($get_row->large_unit_contain),
					'lg_unit_qty'        => to_decimal($get_row->sales_order_detail_large_unit_quantity),
					'lg_unit_prc'        => number_format($get_row->sales_order_detail_large_unit_price),
					'result_large'       => $get_row->sales_order_detail_result_large,
					'md_unit'            => $get_row->sales_order_detail_medium_unit,
					'md_unit_cnt'        => to_decimal($get_row->medium_unit_contain),
					'md_unit_qty'        => to_decimal($get_row->sales_order_detail_medium_unit_quantity),
					'md_unit_prc'        => number_format($get_row->sales_order_detail_medium_unit_price),
					'result_medium'      => $get_row->sales_order_detail_result_medium,
					'sm_unit'            => $get_row->sales_order_detail_small_unit,
					'sm_unit_cnt'        => to_decimal($get_row->small_unit_contain),
					'sm_unit_qty'        => to_decimal($get_row->sales_order_detail_small_unit_quantity),
					'sm_unit_prc'        => number_format($get_row->sales_order_detail_small_unit_price),
					'result_small'       => $get_row->sales_order_detail_result_small,
					'ppn_status'         => $get_row->sales_order_detail_ppn_status,
					'ppn_status_color'   => $ppn_status_color,
					'total'              => number_format($get_row->sales_order_detail_total),
					'ppn_total'          => to_decimal($get_row->sales_order_detail_ppn_total),
					'total_stock'        => to_decimal($total_stock),
					'total_stock_stored' => to_decimal($total_stock_stored),
				);
				$no++;
			}


		output_json($data);
	}

	public function get_embed()
	{
		$data = [];

		$ppn_data    = $this->Ppn_model->get_data(array('is_active' => '1'))->row();
		$ppn_amount  = (empty($ppn_data) ? 0 : to_decimal($ppn_data->amount));

		$data['content_title'] = 'Data Barang';
		$data['ppn_amount']    = $ppn_amount;
		$this->twiggy_display('adm/sales_orders/embed', $data);
	}

	public function get_data_embed()
	{
		$data     = [];
		$response = [];
		$search   = $this->input->post('search');
		$customer = $this->input->post('customer');

		$get_data = $this->Items_model->get_data_search($search)->result();

		$no = 0;
		foreach($get_data as $get_row)
		{	
			$large_unit_price  = $get_row->last_selling_price_large_unit;
			$medium_unit_price = $get_row->last_selling_price_medium_unit;
			$small_unit_price  = $get_row->last_selling_price_small_unit;

			$where_special_price    = array('a.customer_id' => $customer, 'a.item_id' => $get_row->item_id);
			$get_data_special_price = $this->Special_prices_model->get_data($where_special_price)->row();

			$group_customer_id    = $this->Customers_model->get_data(array('customer_id' => $customer))->row()->group_customer_id;
			$where_group_price    = array('a.group_customer_id' => $group_customer_id, 'a.item_id' => $get_row->item_id, 'a.price !=' => 0);
			$get_data_group_price = $this->Group_prices_model->get_data_group_price($where_group_price)->row();

			if($get_data_special_price){
				$large_unit_price = $get_data_special_price->price;
			}

			if($get_data_group_price){
				$large_unit_price = $get_data_group_price->price;
			}

			$total_stock     = 0;
			$where_stock     = array('log_item_id' => $get_row->item_id);
			$get_data_stock  = $this->Logs_model->get_data_last($where_stock)->row_array();
			if($get_data_stock){
				$total_stock = $get_data_stock['log_total_stock'];
			}

			$ppn_status_color = "";
			if($get_row->ppn_status == '1'){
				$ppn_status_color = "";
			}elseif($get_row->ppn_status == '2'){
				$ppn_status_color = "bg-success";
			}else{
				$ppn_status_color = "bg-warning";
			}

			$bg_min_stock = "";
			$left_stock_large = 0;
			$left_stock_large = (to_decimal($total_stock)/to_decimal($get_row->large_unit_contain));
			if($left_stock_large <= to_decimal($get_row->minimum_stock)){
				$bg_min_stock = "bg-danger";
			}

			//
			$data[] = array(
					'no'                 => $no,
					'id'                 => $get_row->item_id,
					'name'               => $get_row->item_name,
					'group_id'           => $get_row->group_id,
					'group_name'         => $get_row->group_name,
					'group_child_id'     => $get_row->group_child_id,
					'group_child_name'   => $get_row->group_child_name,
					'lg_unit'            => $get_row->large_unit,
					'lg_unit_cnt'        => to_decimal($get_row->large_unit_contain),
					'lg_unit_prc'        => number_format($large_unit_price),
					'md_unit'            => $get_row->medium_unit,
					'md_unit_cnt'        => to_decimal($get_row->medium_unit_contain),
					'md_unit_prc'        => number_format($medium_unit_price),
					'sm_unit'            => $get_row->small_unit,
					'sm_unit_cnt'        => to_decimal($get_row->small_unit_contain),
					'sm_unit_prc'        => number_format($small_unit_price),
					'total_stock'        => to_decimal($total_stock),
					'total_stock_stored' => to_decimal($total_stock),
					'minimum_stock'      => to_decimal($get_row->minimum_stock),
					'bg_min_stock'		 => $bg_min_stock,
					'ppn_total'          => 0,
					'ppn_status'         => $get_row->ppn_status,
					'ppn_status_color'   => $ppn_status_color,
					'btncolor'           => '',
					'btnicon'            => '',
			);

			$no++;
		}

		$response = [
            'data'         => $data,
            'recordsTotal' => count($data)
        ];

		output_json($response);
		
	}

	public function save()
	{	
		date_default_timezone_set('Asia/Jakarta');

		$id              = $this->input->post('id');
		$number          = $this->input->post("number");
		$date            = $this->input->post("date");
		$customer        = $this->input->post("customer");
		$payment_method  = $this->input->post("payment_method");
		$payment_term    = $this->input->post("payment_term");
		$payment_due     = $this->input->post("payment_due");
		$grand_total     = $this->input->post("grand_total");
		$ppn_total       = $this->input->post("ppn_total");
		$paid_total      = $this->input->post("paid_total");
		$change_total    = $this->input->post("change_total");
		$remaining_total = $this->input->post("remaining_total");
		$description     = $this->input->post("description");

		$hold_status     = $this->input->post("hold_status");
		$ppn_amount      = $this->input->post("ppn_amount");

		$btn_action = $this->input->post("btn_action");

		$user_id = logged_user('id');
		
		$vuedata = $this->input->post('vuedata');

		// echo json_encode($vuedata);
		// die();

		$payment_term_data = ($payment_term == "" ? "0" : $payment_term);
		$payment_due_data  = ($payment_due == "" ? "0000-00-00" : change_format_date($payment_due));
		$status_paid 	   = ($payment_method == 'Tunai' ? 1 : 0);
		$is_hold = 0;
		$printed_date = date_now();

		if($hold_status == 0){
			$printed_date = change_format_date($date);
		}

		if($btn_action == 'hold'){ 
			$status_paid = 0; 
			$is_hold = 1; 
			// $printed_date = "0000-00-00";
		}

		$header_id   = $id;
		$header_data = [
			'sales_order_header_number'          => $number,
			'sales_order_header_date'            => change_format_date($date),
			'sales_order_header_customer_id'     => $customer,
			'sales_order_header_payment_method'  => $payment_method,
			'sales_order_header_payment_term'    => $payment_term_data,
			'sales_order_header_payment_due'     => $payment_due_data,
			'sales_order_header_grand_total'     => trims($grand_total),
			'sales_order_header_ppn_total'       => trims($ppn_total),
			'sales_order_header_paid_total'      => trims($paid_total),
			'sales_order_header_change_total'    => trims($change_total),
			'sales_order_header_remaining_total' => trims($remaining_total),
			'sales_order_header_description'     => $description,
			'sales_order_header_user_id'         => $user_id,
			'status_paid'                        => $status_paid,
			'is_hold'                            => $is_hold,
			'printed_date'                       => $printed_date,
			'ppn_amount'                         => $ppn_amount
		];

		$detail_data = [];
		$log_data = [];

		// if save $id = new else update data

		

		if(isset($id) && $id != '' && $id != NULL){
			if($vuedata){
				if($id == "new")
				{
					// save header
					$save_header = $this->Sales_orders_model->save_header($header_data);
					if($save_header)
					{
						$header_id = $this->db->insert_id();
						foreach($vuedata as $row)
						{
							$detail_data[] = [
								'sales_order_detail_header_id'            => $header_id,
								'sales_order_detail_item_id'              => $row['id'],
								'sales_order_detail_item_name'            => $row['name'],
								'sales_order_detail_large_unit'           => $row['lg_unit'],
								'sales_order_detail_large_unit_quantity'  => trims($row['lg_unit_qty']),
								'sales_order_detail_large_unit_price'     => trims($row['lg_unit_prc']),
								'sales_order_detail_result_large'         => trims($row['result_large']),
								'sales_order_detail_medium_unit'          => $row['md_unit'],
								'sales_order_detail_medium_unit_quantity' => trims($row['md_unit_qty']),
								'sales_order_detail_medium_unit_price'    => trims($row['md_unit_prc']),
								'sales_order_detail_result_medium'        => trims($row['result_medium']),
								'sales_order_detail_small_unit'           => $row['sm_unit'],
								'sales_order_detail_small_unit_quantity'  => trims($row['sm_unit_qty']),
								'sales_order_detail_small_unit_price'     => trims($row['sm_unit_prc']),
								'sales_order_detail_result_small'         => trims($row['result_small']),
								'sales_order_detail_ppn_status'           => $row['ppn_status'],
								'sales_order_detail_ppn_total'            => trims($row['ppn_total']),
								'sales_order_detail_total'                => trims($row['total'])
							];
	
							$where                 = array('log_item_id' => $row['id']);
							$log_data_check        = $this->Logs_model->get_data_last($where)->row_array();
							$last_total_stock      = 0;
							$last_log_total_stock_value = 0;
							$last_log_avg_large = 0;
							$last_log_avg_medium = 0;
							$last_log_avg_small = 0;
	
							if(!empty($log_data_check)){
								$last_total_stock           = $log_data_check['log_total_stock'];
								$last_log_total_stock_value = $log_data_check['log_total_stock_value'];
								$last_log_avg_large         = $log_data_check['log_average_large_unit'];
								$last_log_avg_medium        = $log_data_check['log_average_medium_unit'];
								$last_log_avg_small         = $log_data_check['log_average_small_unit'];
							}
	
							$medium_purchase_price = ($row['md_unit_cnt'] == 0 ? 0 : ($last_log_avg_medium));
							$small_purchase_price  = ($row['sm_unit_cnt'] == 0 ? 0 : ($last_log_avg_small));
	
							$log_total_transaction_in_small_unit = ($row['lg_unit_cnt'] * (- trims($row['lg_unit_qty']))) + ($row['md_unit_cnt'] * (- trims($row['md_unit_qty']))) + ($row['sm_unit_cnt'] * (- trims($row['sm_unit_qty'])));
							$log_total_transaction_value = ((- trims($row['lg_unit_qty'])) * $last_log_avg_large) + ((- trims($row['md_unit_qty'])) * $medium_purchase_price) + ((- trims($row['sm_unit_qty'])) * $small_purchase_price);
							$log_total_stock		     = ($last_total_stock + $log_total_transaction_in_small_unit);
							$log_total_stock_value       = ($last_log_total_stock_value + $log_total_transaction_value);
							// $log_average_small_unit      = ($log_total_stock_value / $log_total_stock);
							$log_average_small_unit      = ($log_total_stock == 0 ? 0 : ($log_total_stock_value / $log_total_stock));
							$log_average_medium_unit     = ($log_average_small_unit * $row['md_unit_cnt']);
							$log_average_large_unit      = ($log_average_small_unit * $row['lg_unit_cnt']);
	
							$log_data[] = [
								'log_type'                            => 'SELL',
								'log_transaction_id'                  => $header_id,
								'log_item_id'                         => $row['id'],
								'log_large_unit'                      => $row['lg_unit'],
								'log_large_unit_contain'              => $row['lg_unit_cnt'],
								'log_large_unit_quantity'             => (- trims($row['lg_unit_qty'])),
								'log_large_unit_purchase_price'       => $last_log_avg_large,
								'log_large_unit_selling_price'        => trims($row['lg_unit_prc']),
								'log_medium_unit'                     => $row['md_unit'],
								'log_medium_unit_contain'             => $row['md_unit_cnt'],
								'log_medium_unit_quantity'            => (- trims($row['md_unit_qty'])),
								'log_medium_unit_purchase_price'      => $medium_purchase_price,
								'log_medium_unit_selling_price'       => trims($row['md_unit_prc']),
								'log_small_unit'                      => $row['sm_unit'],
								'log_small_unit_contain'              => $row['sm_unit_cnt'],
								'log_small_unit_quantity'             => (- trims($row['sm_unit_qty'])),
								'log_small_unit_purchase_price'       => $small_purchase_price,
								'log_small_unit_selling_price'        => trims($row['sm_unit_prc']),
								'log_total_transaction_in_small_unit' => $log_total_transaction_in_small_unit,
								'log_total_transaction_value'         => $log_total_transaction_value,
								'log_total_stock'                     => $log_total_stock,
								'log_total_stock_value'               => $log_total_stock_value,
								'log_average_large_unit'              => $log_average_large_unit,
								'log_average_medium_unit'             => $log_average_medium_unit,
								'log_average_small_unit'              => $log_average_small_unit
							];
	
							// $data_item = array(
							// 	'last_selling_price_large_unit'  => trims($row['lg_unit_prc']),
							// 	'last_selling_price_medium_unit' => trims($row['md_unit_prc']),
							// 	'last_selling_price_small_unit'  => trims($row['sm_unit_prc']),
							// );
	
							// $where_item = $row['id'];
	
							// $update_item = $this->Items_model->update($where_item, $data_item);
						}
						
						$save_detail = $this->Sales_orders_model->save_detail($detail_data, true);
						
						if($save_detail)
						{	
							$save_log = $this->Logs_model->save($log_data, true);
	
							if($save_log)
							{	
								$s_trx = 'new';
								$checkpoint = $this->checkpoint($s_trx, $header_id, $date, $customer);
								if($checkpoint)
								{
									$msg    = "Berhasil menyimpan data";
									$status = "success";
								}else{
									$msg    = "Gagal menyimpan data #CKP-S01";
									$status = "error";	
								}
							}
							else
							{
								$msg    = "Gagal menyimpan data #LOG-S01";
								$status = "error";	
							}
						}
						else
						{
							$msg    = "Gagal menyimpan data #DET-S01";
							$status = "error";	
						}
					}
					else
					{
						$msg    = "Gagal menyimpan data #HED-S01";
						$status = "error";	
					}
					
				}else{
					
					$delete_detail = $this->Sales_orders_model->delete_detail($id);
	
					if ($delete_detail) {
						$save_header = $this->Sales_orders_model->update_header($id, $header_data);
	
						if($save_header)
						{
							// $header_id = $this->db->insert_id();
							foreach($vuedata as $row)
							{
								$detail_data[] = [
									'sales_order_detail_header_id'            => $header_id,
									'sales_order_detail_item_id'              => $row['id'],
									'sales_order_detail_item_name'            => $row['name'],
									'sales_order_detail_large_unit'           => $row['lg_unit'],
									'sales_order_detail_large_unit_quantity'  => trims($row['lg_unit_qty']),
									'sales_order_detail_large_unit_price'     => trims($row['lg_unit_prc']),
									'sales_order_detail_result_large'         => trims($row['result_large']),
									'sales_order_detail_medium_unit'          => $row['md_unit'],
									'sales_order_detail_medium_unit_quantity' => trims($row['md_unit_qty']),
									'sales_order_detail_medium_unit_price'    => trims($row['md_unit_prc']),
									'sales_order_detail_result_medium'        => trims($row['result_medium']),
									'sales_order_detail_small_unit'           => $row['sm_unit'],
									'sales_order_detail_small_unit_quantity'  => trims($row['sm_unit_qty']),
									'sales_order_detail_small_unit_price'     => trims($row['sm_unit_prc']),
									'sales_order_detail_result_small'         => trims($row['result_small']),
									'sales_order_detail_ppn_status'           => $row['ppn_status'],
									'sales_order_detail_ppn_total'            => trims($row['ppn_total']),
									'sales_order_detail_total'                => trims($row['total'])
								];
	
								// $data_item = array(
								// 	'last_selling_price_large_unit'  => trims($row['lg_unit_prc']),
								// 	'last_selling_price_medium_unit' => trims($row['md_unit_prc']),
								// 	'last_selling_price_small_unit'  => trims($row['sm_unit_prc']),
								// );
	
								// $where_item = $row['id'];
	
								// $update_item = $this->Items_model->update($where_item, $data_item);
	
								$where_check = array('log_type' => 'SELL', 'log_transaction_id' => $header_id, 'log_item_id' => $row['id']);
								$logs_id_check = $this->Logs_model->get_data($where_check)->row();
								if(!empty($logs_id_check)){
									$where_a = array('log_type' => 'SELL', 'log_transaction_id' => $header_id, 'log_item_id' => $row['id']);
									$logs_id_a = $this->Logs_model->get_data($where_a)->row()->log_id;
									$where_b = array('log_item_id' => $row['id'], 'log_id <' => $logs_id_a);
									$log_data_check = $this->Logs_model->get_data_last($where_b)->row_array();
									$last_total_stock      = 0;
									$last_log_total_stock_value = 0;
									$last_log_avg_large = 0;
									$last_log_avg_medium = 0;
									$last_log_avg_small = 0;
	
									if(!empty($log_data_check)){
										$last_total_stock           = $log_data_check['log_total_stock'];
										$last_log_total_stock_value = $log_data_check['log_total_stock_value'];
										$last_log_avg_large         = $log_data_check['log_average_large_unit'];
										$last_log_avg_medium        = $log_data_check['log_average_medium_unit'];
										$last_log_avg_small         = $log_data_check['log_average_small_unit'];
									}
	
									$medium_purchase_price = ($row['md_unit_cnt'] == 0 ? 0 : ($last_log_avg_medium));
									$small_purchase_price = ($row['sm_unit_cnt'] == 0 ? 0 : ($last_log_avg_small));
	
									$log_total_transaction_in_small_unit = ($row['lg_unit_cnt'] * (- trims($row['lg_unit_qty']))) + ($row['md_unit_cnt'] * (- trims($row['md_unit_qty']))) + ($row['sm_unit_cnt'] * (- trims($row['sm_unit_qty'])));
									$log_total_transaction_value = ((- trims($row['lg_unit_qty'])) * $last_log_avg_large) + ((- trims($row['md_unit_qty'])) * $medium_purchase_price) + ((- trims($row['sm_unit_qty'])) * $small_purchase_price);
									$log_total_stock		     = ($last_total_stock + $log_total_transaction_in_small_unit);
									$log_total_stock_value       = ($last_log_total_stock_value + $log_total_transaction_value);
									// $log_average_small_unit      = ($log_total_stock_value / $log_total_stock);
									$log_average_small_unit      = ($log_total_stock == 0 ? 0 : ($log_total_stock_value / $log_total_stock));
									$log_average_medium_unit     = ($log_average_small_unit * $row['md_unit_cnt']);
									$log_average_large_unit      = ($log_average_small_unit * $row['lg_unit_cnt']);
									
									$this_row_data_update = array(
										'log_type'                            => 'SELL',
										'log_transaction_id'                  => $header_id,
										'log_item_id'                         => $row['id'],
										'log_large_unit'                      => $row['lg_unit'],
										'log_large_unit_contain'              => $row['lg_unit_cnt'],
										'log_large_unit_quantity'             => (- trims($row['lg_unit_qty'])),
										'log_large_unit_purchase_price'       => $last_log_avg_large,
										'log_large_unit_selling_price'        => trims($row['lg_unit_prc']),
										'log_medium_unit'                     => $row['md_unit'],
										'log_medium_unit_contain'             => $row['md_unit_cnt'],
										'log_medium_unit_quantity'            => (- trims($row['md_unit_qty'])),
										'log_medium_unit_purchase_price'      => $medium_purchase_price,
										'log_medium_unit_selling_price'       => trims($row['md_unit_prc']),
										'log_small_unit'                      => $row['sm_unit'],
										'log_small_unit_contain'              => $row['sm_unit_cnt'],
										'log_small_unit_quantity'             => (- trims($row['sm_unit_qty'])),
										'log_small_unit_purchase_price'       => $small_purchase_price,
										'log_small_unit_selling_price'        => trims($row['sm_unit_prc']),
										'log_total_transaction_in_small_unit' => $log_total_transaction_in_small_unit,
										'log_total_transaction_value'         => $log_total_transaction_value,
										'log_total_stock'                     => $log_total_stock,
										'log_total_stock_value'               => $log_total_stock_value,
										'log_average_large_unit'              => $log_average_large_unit,
										'log_average_medium_unit'             => $log_average_medium_unit,
										'log_average_small_unit'              => $log_average_small_unit
									);
	
									$this_row_where_update = array(
										'log_type' => 'SELL',
										'log_transaction_id' => $header_id,
										'log_item_id'        => $row['id'],
									);
	
									$this_row_log_update = $this->Logs_model->update_item($this_row_where_update, $this_row_data_update);
								}else{
									$where_z               = array('log_item_id' => $row['id']);
									$log_data_check        = $this->Logs_model->get_data_last($where_z)->row_array();
									$last_total_stock      = 0;
									$last_log_total_stock_value = 0;
									$last_log_avg_large = 0;
									$last_log_avg_medium = 0;
									$last_log_avg_small = 0;
	
									if(!empty($log_data_check)){
										$last_total_stock      		= $log_data_check['log_total_stock'];
										$last_log_total_stock_value = $log_data_check['log_total_stock_value'];
										$last_log_avg_large = $log_data_check['log_average_large_unit'];
										$last_log_avg_medium        = $log_data_check['log_average_medium_unit'];
										$last_log_avg_small         = $log_data_check['log_average_small_unit'];
									}
	
									$medium_purchase_price = ($row['md_unit_cnt'] == 0 ? 0 : ($last_log_avg_medium));
									$small_purchase_price = ($row['sm_unit_cnt'] == 0 ? 0 : ($last_log_avg_small));
	
									$log_total_transaction_in_small_unit = ($row['lg_unit_cnt'] * (- trims($row['lg_unit_qty']))) + ($row['md_unit_cnt'] * (- trims($row['md_unit_qty']))) + ($row['sm_unit_cnt'] * (- trims($row['sm_unit_qty'])));
									$log_total_transaction_value = ((- trims($row['lg_unit_qty'])) * $last_log_avg_large) + ((- trims($row['md_unit_qty'])) * $medium_purchase_price) + ((- trims($row['sm_unit_qty'])) * $small_purchase_price);
									$log_total_stock		     = ($last_total_stock + $log_total_transaction_in_small_unit);
									$log_total_stock_value       = ($last_log_total_stock_value + $log_total_transaction_value);
									// $log_average_small_unit      = ($log_total_stock_value / $log_total_stock);
									$log_average_small_unit      = ($log_total_stock == 0 ? 0 : ($log_total_stock_value / $log_total_stock));
									$log_average_medium_unit     = ($log_average_small_unit * $row['md_unit_cnt']);
									$log_average_large_unit      = ($log_average_small_unit * $row['lg_unit_cnt']);
									
									$this_row_data_save = array(
										'log_type'                            => 'SELL',
										'log_transaction_id'                  => $header_id,
										'log_item_id'                         => $row['id'],
										'log_large_unit'                      => $row['lg_unit'],
										'log_large_unit_contain'              => $row['lg_unit_cnt'],
										'log_large_unit_quantity'             => (- trims($row['lg_unit_qty'])),
										'log_large_unit_purchase_price'       => $last_log_avg_large,
										'log_large_unit_selling_price'        => trims($row['lg_unit_prc']),
										'log_medium_unit'                     => $row['md_unit'],
										'log_medium_unit_contain'             => $row['md_unit_cnt'],
										'log_medium_unit_quantity'            => (- trims($row['md_unit_qty'])),
										'log_medium_unit_purchase_price'      => $medium_purchase_price,
										'log_medium_unit_selling_price'       => trims($row['md_unit_prc']),
										'log_small_unit'                      => $row['sm_unit'],
										'log_small_unit_contain'              => $row['sm_unit_cnt'],
										'log_small_unit_quantity'             => (- trims($row['sm_unit_qty'])),
										'log_small_unit_purchase_price'       => $small_purchase_price,
										'log_small_unit_selling_price'        => trims($row['sm_unit_prc']),
										'log_total_transaction_in_small_unit' => $log_total_transaction_in_small_unit,
										'log_total_transaction_value'         => $log_total_transaction_value,
										'log_total_stock'                     => $log_total_stock,
										'log_total_stock_value'               => $log_total_stock_value,
										'log_average_large_unit'              => $log_average_large_unit,
										'log_average_medium_unit'             => $log_average_medium_unit,
										'log_average_small_unit'              => $log_average_small_unit
									);
	
									$this_row_log_update = $this->Logs_model->save($this_row_data_save);
								}
	
	
								// Update Data After ::::
								if($this_row_log_update){
									$where_1 = array('log_type' => 'SELL', 'log_transaction_id' => $header_id, 'log_item_id' => $row['id']);
									$logs_id = $this->Logs_model->get_data($where_1)->row()->log_id;
	
									$where_2 = array('log_item_id' => $row['id'], 'log_id >' => $logs_id);
									$get_data_all_logs_by_item = $this->Logs_model->get_data($where_2)->result();
	
									foreach ($get_data_all_logs_by_item as $row) {
	
										$where_3 = array('log_item_id' => $row->log_item_id, 'log_id <' => $row->log_id);
										$one_line_before_log_data  = $this->Logs_model->get_data_last($where_3)->row_array();
										$one_line_before_total     = 0;
										$one_line_before_log_total = 0;
										$one_line_before_log_avg_large = 0;
	
										if(!empty($one_line_before_log_data)){
											$one_line_before_total     = $one_line_before_log_data['log_total_stock'];
											$one_line_before_log_total = $one_line_before_log_data['log_total_stock_value'];
											$one_line_before_log_avg_large = $one_line_before_log_data['log_average_large_unit'];
										}
										$log_total_stock	     = ($one_line_before_total + $row->log_total_transaction_in_small_unit);
										$log_total_stock_value   = ($one_line_before_log_total + $row->log_total_transaction_value);
										// $log_average_small_unit  = ($log_total_stock_value / $log_total_stock);
										$log_average_small_unit      = ($log_total_stock == 0 ? 0 : ($log_total_stock_value / $log_total_stock));
										$log_average_medium_unit = ($log_average_small_unit * $row->medium_unit_contain);
										$log_average_large_unit  = ($log_average_small_unit * $row->large_unit_contain);
										$after_row_data_update = array(
											'log_id'                  => $row->log_id,
											'log_total_stock'         => $log_total_stock,
											'log_total_stock_value'   => $log_total_stock_value,
											'log_average_large_unit'  => $log_average_large_unit,
											'log_average_medium_unit' => $log_average_medium_unit,
											'log_average_small_unit'  => $log_average_small_unit
										);
	
										$after_row_where_update = array(
											'log_id' => $row->log_id,
										);
	
										$after_row_log_update = $this->Logs_model->update_item($after_row_where_update, $after_row_data_update);
									}
								}
							}
	
							$save_detail = $this->Sales_orders_model->save_detail($detail_data, true);
							
							if($save_detail){
								$where_check_item_id  = array('log_type' => 'SELL', 'log_transaction_id' => $header_id);
								$get_data_log_item_id = $this->Logs_model->get_data($where_check_item_id)->result();
	
								foreach ($get_data_log_item_id as $row_list) {
	
									$where_item_id = array('sales_order_detail_header_id' => $header_id, 'item_id' => $row_list->log_item_id);
									$get_data_po_detail_now = $this->Sales_orders_model->salesorder_detail($where_item_id)->result();
	
									if(!empty($get_data_po_detail_now)){
										$after_row_log_update = true;
									}else{
										
										// Get Data Before This Item ID :::
										$where_before = array('log_item_id' => $row_list->log_item_id, 'log_id <' => $row_list->log_id);
										$get_before_data = $this->Logs_model->get_data_last($where_before)->row_array();
										$get_before_total_stock       = 0;
										$get_before_total_stock_value = 0;
										$get_before_avg_large = 0;
	
										if(!empty($get_before_data)){
											$get_before_total_stock = $get_before_data['log_total_stock'];
											$get_before_total_stock_value = $get_before_data['log_total_stock_value'];
											$get_before_avg_large = $get_before_data['log_average_large_unit'];
										}
	
										// Get Data After This Item ID :::
										$where_after = array('log_item_id' => $row_list->log_item_id, 'log_id >' => $row_list->log_id);
										$get_after_data = $this->Logs_model->get_data($where_after)->result();
										
										if($get_after_data){
											foreach ($get_after_data as $row_list_detail) {
												$where_log_delete = array(
													'log_item_id' => $row_list->log_item_id, 
													'log_id' => $row_list->log_id
												);
	
												$delete_logs = $this->Logs_model->delete($where_log_delete);
										
												$where_this = array('log_type' => 'SELL', 'log_transaction_id' => $row_list_detail->log_transaction_id, 'log_item_id' => $row_list_detail->log_item_id);
												$log_id = $this->Logs_model->get_data($where_this)->row()->log_id;
												
												$where_3 = array('log_item_id' => $row_list_detail->log_item_id, 'log_id <' => $log_id);
												$one_line_before_log_data  = $this->Logs_model->get_data_last($where_3)->row_array();
												$one_line_before_total     = 0;
												$one_line_before_log_total = 0;
												$one_line_before_log_avg_large = 0;
	
												if(!empty($one_line_before_log_data)){
													$one_line_before_total     = $one_line_before_log_data['log_total_stock'];
													$one_line_before_log_total = $one_line_before_log_data['log_total_stock_value'];
													$one_line_before_log_avg_large = $one_line_before_log_data['log_average_large_unit'];
												}
												
												$log_total_stock	     = ($one_line_before_total + $row_list_detail->log_total_transaction_in_small_unit);
												$log_total_stock_value   = ($one_line_before_log_total + $row_list_detail->log_total_transaction_value);
												// $log_average_small_unit  = ($log_total_stock_value / $log_total_stock);
												$log_average_small_unit      = ($log_total_stock == 0 ? 0 : ($log_total_stock_value / $log_total_stock));
												$log_average_medium_unit = ($log_average_small_unit * $row_list_detail->medium_unit_contain);
												$log_average_large_unit  = ($log_average_small_unit * $row_list_detail->large_unit_contain);
												$after_row_data_update = array(
													'log_id'                  => $row_list_detail->log_id,
													'log_total_stock'         => $log_total_stock,
													'log_total_stock_value'   => $log_total_stock_value,
													'log_average_large_unit'  => $log_average_large_unit,
													'log_average_medium_unit' => $log_average_medium_unit,
													'log_average_small_unit'  => $log_average_small_unit
												);
	
												// echo json_encode($after_row_data_update);
												$after_row_where_update = array(
													'log_id' => $row_list_detail->log_id,
												);
	
												$after_row_log_update = $this->Logs_model->update_item($after_row_where_update, $after_row_data_update);
											}
										}else{
											$where_log_delete = array(
													'log_item_id' => $row_list->log_item_id, 
													'log_id' => $row_list->log_id
												);
	
											$delete_logs = $this->Logs_model->delete($where_log_delete);
	
											$after_row_log_update = true;
										}
									}
								}
							}
							else
							{
								$msg    = "Gagal menyimpan data #DET-U01";
								$status = "error";	
							}
	
							if($after_row_log_update)
							{
								$s_trx = 'update';
								$checkpoint = $this->checkpoint($s_trx, $header_id, $date, $customer);
								if($checkpoint)
								{
									$msg    = "Berhasil menyimpan data";
									$status = "success";
								}else{
									$msg    = "Gagal menyimpan data #CKP-U01";
									$status = "error";	
								}
							}
							else
							{
								$msg    = "Gagal menyimpan data #LOG-U01";
								$status = "error";	
							}
						}
						else{
							$msg    = "Gagal menyimpan data #HED-U01";
							$status = "error";
						}
	
					}
					else{
						$msg    = "Gagal menyimpan data #DEL-U01";
						$status = "error";
					}
				}
			}else{
				$msg    = "Gagal menyimpan data, detail tidak terbaca.";
				$status = "error";
			}
		}else{
			$msg    = "Gagal menyimpan data, id tidak terbaca.";
			$status = "error";
		}

		$response = [
			'message'    => $msg,
			'status'     => $status,
			'id'         => $header_id,
			'btn_action' => $btn_action
		];
		output_json($response);

	}

	public function delete()
	{
		$id = $this->input->post('id');
		$data_log = [];
		foreach($id as $row)
		{	
			$where = array('log_type' => 'SELL', 'log_transaction_id' => $row);
			$get_data_log = $this->Logs_model->get_data($where)->result();

			foreach ($get_data_log as $row_list) {

				// Get Data After This Item ID :::
				$where_after = array('log_item_id' => $row_list->log_item_id, 'log_id >' => $row_list->log_id);
				$get_after_data = $this->Logs_model->get_data($where_after)->result();

				if($get_after_data){
					foreach ($get_after_data as $row_list_detail) {
					
						$where_log_delete = array(
							'log_item_id' => $row_list->log_item_id, 
							'log_id' => $row_list->log_id
						);

						$delete_logs = $this->Logs_model->delete($where_log_delete);
						
						$where_this = array('log_id' => $row_list_detail->log_id, 'log_item_id' => $row_list_detail->log_item_id);
						$log_id = $this->Logs_model->get_data($where_this)->row()->log_id;
						// The Keys
						// $where_this = array('log_type' => 'SELL', 'log_transaction_id' => $row_list_detail->log_transaction_id, 'log_item_id' => $row_list_detail->log_item_id);
						// $log_id = $this->Logs_model->get_data($where_this)->row()->log_id;
						
						$where_3 = array('log_item_id' => $row_list_detail->log_item_id, 'log_id <' => $log_id);
						$one_line_before_log_data  = $this->Logs_model->get_data_last($where_3)->row_array();
						$one_line_before_total     = 0;
						$one_line_before_log_total = 0;
						$one_line_before_log_avg_large = 0;

						if(!empty($one_line_before_log_data)){
							$one_line_before_total     = $one_line_before_log_data['log_total_stock'];
							$one_line_before_log_total = $one_line_before_log_data['log_total_stock_value'];
							$one_line_before_log_avg_large = $one_line_before_log_data['log_average_large_unit'];
						}

						$log_total_stock	     = ($one_line_before_total + $row_list_detail->log_total_transaction_in_small_unit);
						$log_total_stock_value   = ($one_line_before_log_total + $row_list_detail->log_total_transaction_value);
						// $log_average_small_unit  = ($log_total_stock_value / $log_total_stock);
						$log_average_small_unit      = ($log_total_stock == 0 ? 0 : ($log_total_stock_value / $log_total_stock));
						$log_average_medium_unit = ($log_average_small_unit * $row_list_detail->medium_unit_contain);
						$log_average_large_unit  = ($log_average_small_unit * $row_list_detail->large_unit_contain);

						$after_row_data_update = array(
							'log_id'                  => $row_list_detail->log_id,
							'log_total_stock'         => $log_total_stock,
							'log_total_stock_value'   => $log_total_stock_value,
							'log_average_large_unit'  => $log_average_large_unit,
							'log_average_medium_unit' => $log_average_medium_unit,
							'log_average_small_unit'  => $log_average_small_unit
						);

						$after_row_where_update = array(
							'log_id' => $row_list_detail->log_id,
						);

						$after_row_log_update = $this->Logs_model->update_item($after_row_where_update, $after_row_data_update);
					}
				}else{
					$where_log_delete = array(
						'log_item_id' => $row_list->log_item_id, 
						'log_id' => $row_list->log_id
					);

					$delete_logs = $this->Logs_model->delete($where_log_delete);
				}
			}

			$delete_header = $this->Sales_orders_model->delete_header($row);

			$s_trx = 'delete';
			$checkpoint = $this->checkpoint($s_trx, $row);
						
			if($delete_header){
				$delete_type = $this->Sales_orders_model->delete_detail($row);
			}
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function print_out_backup($id)
	{	
		$where_header = array('sales_order_header_id' => $id);
		$where_detail = array('sales_order_detail_header_id' => $id);

		$header = $this->Sales_orders_model->salesorder_header($where_header)->row_array();
		$detail = $this->Sales_orders_model->salesorder_detail($where_detail)->result();

		$data['content_title'] = 'Print Penjualan';
		$data['header'] = $header;
		$data['detail'] = $detail;

		$this->twiggy_display('adm/sales_orders/print_out', $data);
	}

	public function print_out($id)
	{	
		date_default_timezone_set('Asia/Jakarta');
		$where_header = array('sales_order_header_id' => $id);
		$where_config1 = array('ppn_status' => '1', 'is_active' => '1');
		$where_config2 = array('ppn_status' => '2', 'is_active' => '1');
		$where_config3 = array('ppn_status' => '3', 'is_active' => '1');
		
		$header          = $this->Sales_orders_model->salesorder_header($where_header)->row_array();
		$config_receipt1 = $this->Configuration_model->get_data_invoice($where_config1)->row_array();
		$config_receipt2 = $this->Configuration_model->get_data_invoice($where_config2)->row_array();
		$config_receipt3 = $this->Configuration_model->get_data_invoice($where_config3)->row_array();
		// $user_handle = $this->Users_model->get_data_advance($header['sales_order_header_user_id'])->row()->fullname;
		$customer_name = $header['customer_name'];
		$customer_ktp  = $header['customer_ktp'];
		$customer_npwp = $header['customer_npwp'];

		$printed_date = $header['printed_date'];
		if($printed_date == '0000-00-00'){
			$printed_date = $header['sales_order_header_date'];
		}
		
		// $printed_date = date('H:i:s');
		$get_data     = $this->Sales_orders_model->ppn_status('', 'FIELD(ppn_status_id, "3", "1", "2")')->result();
		
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $k => $get_row)
			{
				$response[] = [
					'number' => $no,
					'ppn_id'     => $get_row->ppn_status_id,
					'ppn_name'   => $get_row->ppn_status_name
				];

				$where_detail = array('sales_order_detail_header_id' => $id, 'sales_order_detail_ppn_status' => $get_row->ppn_status_id);
				$temp = $this->Sales_orders_model->salesorder_detail2($where_detail, 'large_unit_pr asc, medium_unit_pr asc, small_unit_pr asc')->result();
				$a = 0;
				$b = 0;
				$c = 0;
				$d = 0;
				$np = 0;

				foreach ($temp as $key => $value) {

					$dppTotal = $value->sales_order_detail_result_large + $value->sales_order_detail_result_medium + $value->sales_order_detail_result_small;

					$dppTotalRnd = round($value->sales_order_detail_result_large + $value->sales_order_detail_result_medium + $value->sales_order_detail_result_small, -2);
					$ppnTotal = $value->sales_order_detail_ppn_total;
					$tax_percentage = ($ppnTotal/$dppTotal) * 100;

					$price_large   = $value->sales_order_detail_large_unit_price + ($value->sales_order_detail_large_unit_price * ($tax_percentage/100));
					$result_large  = (round($price_large) * $value->sales_order_detail_large_unit_quantity);
					$price_medium  = $value->sales_order_detail_medium_unit_price + ($value->sales_order_detail_medium_unit_price * ($tax_percentage/100));
					$result_medium = (round($price_medium) * $value->sales_order_detail_medium_unit_quantity);
					$price_small   = $value->sales_order_detail_small_unit_price + ($value->sales_order_detail_small_unit_price * ($tax_percentage/100));
					$result_small  = (round($price_small) * $value->sales_order_detail_small_unit_quantity);


					$response[$k]['detail'][$key] = array(	
						'item_name'       => $value->sales_order_detail_item_name,
						'unit_large'      => $value->sales_order_detail_large_unit,
						'quantity_large'  => to_decimal($value->sales_order_detail_large_unit_quantity),
						'price_large'     => number_format($price_large),
						'result_large'    => number_format($result_large),
						'unit_medium'     => $value->sales_order_detail_medium_unit,
						'quantity_medium' => to_decimal($value->sales_order_detail_medium_unit_quantity),
						'price_medium'    => number_format($price_medium),
						'result_medium'   => number_format($result_medium),
						'unit_small'      => $value->sales_order_detail_small_unit,
						'quantity_small'  => to_decimal($value->sales_order_detail_small_unit_quantity),
						'price_small'     => number_format($price_small),
						'result_small'    => number_format($result_small),
						'dppTotal'        => number_format($np += (round($value->sales_order_detail_result_large,-2) + round($value->sales_order_detail_result_medium,-2) + round($value->sales_order_detail_result_small,-2))),
						'dppTotalppn'     => number_format((round($a += $value->sales_order_detail_total, -2)/1.1)),
						'ppnTotal'        => number_format((round($b += $value->sales_order_detail_total, -2)/1.1)*10/100),
						'ppndppTotal'     => number_format(round($d += ($dppTotal + $ppnTotal), -2)),
						'grandTotal'      => number_format(round($c += ($value->sales_order_detail_total), -2))
					);

				}
				$no++;
			}
		}
		

		// echo json_encode($response);
		// die();
		$ppn_not_exist = false;
		$nonppn_not_exist = false;
		$special_not_exist = false;
		error_reporting(E_ALL ^ E_NOTICE);
		if (($response[2]['detail']) == undefined or count($response[2]['detail']) == 0) {
			$ppn_not_exist = true;
		}
		
		if (($response[1]['detail']) == undefined or count($response[1]['detail']) == 0) {
			$nonppn_not_exist = true;
		}

		if (($response[0]['detail']) == undefined or count($response[0]['detail']) == 0) {
			$special_not_exist = true;
		}
		
		$data['content_title']     = 'Print Penjualan';
		$data['header']            = $header;
		$data['config_receipt1']   = $config_receipt1;
		$data['config_receipt2']   = $config_receipt2;
		$data['config_receipt3']   = $config_receipt3;
		$data['customer_name']     = $customer_name;
		$data['customer_nik']      = $customer_ktp;
		$data['customer_npwp']     = $customer_npwp;
		$data['printed_date']      = $printed_date;
		$data['maintenance_data']  = $get_data;
		$data['get_data']          = $response;
		$data['ppn_not_exist']     = $ppn_not_exist;
		$data['nonppn_not_exist']  = $nonppn_not_exist;
		$data['special_not_exist'] = $special_not_exist;

		$this->twiggy_display('adm/sales_orders/receipt', $data);
	}

	public function printout_invoice($id)
	{	
		$truncate_stored_invoice = $this->Sales_orders_model->truncate_stored_invoice();
		$fill_stored_invoice     = $this->stored_invoice($id);

		date_default_timezone_set('Asia/Jakarta');
		$where_header = array('sales_order_header_id' => $id);
		$where_config1 = array('ppn_status' => '1', 'is_active' => '1');
		$where_config2 = array('ppn_status' => '2', 'is_active' => '1');
		$where_config3 = array('ppn_status' => '3', 'is_active' => '1');
		
		$header          = $this->Sales_orders_model->salesorder_header($where_header)->row_array();
		$config_receipt1 = $this->Configuration_model->get_data_invoice($where_config1)->row_array();
		$config_receipt2 = $this->Configuration_model->get_data_invoice($where_config2)->row_array();
		$config_receipt3 = $this->Configuration_model->get_data_invoice($where_config3)->row_array();
		// $user_handle = $this->Users_model->get_data_advance($header['sales_order_header_user_id'])->row()->fullname;
		$customer_name = $header['customer_name'];
		$customer_ktp  = $header['customer_ktp'];
		$customer_npwp = $header['customer_npwp'];

		$printed_date = $header['printed_date'];
		if($printed_date == '0000-00-00'){
			$printed_date = $header['sales_order_header_date'];
		}
		
		// $printed_date = date('H:i:s');
		$get_data     = $this->Sales_orders_model->ppn_status('', 'FIELD(ppn_status_id, "3", "1", "2")')->result();
		
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $k => $get_row)
			{
				$response[] = [
					'number' => $no,
					'ppn_id'     => $get_row->ppn_status_id,
					'ppn_name'   => $get_row->ppn_status_name
				];

				$where_detail = array('sales_order_detail_header_id' => $id, 'sales_order_detail_ppn_status' => $get_row->ppn_status_id);
				$temp = $this->Sales_orders_model->salesorder_detail3($where_detail, 'unit_priority')->result();
				$a = 0;
				$b = 0;
				$c = 0;
				$d = 0;
				$np = 0;

				foreach ($temp as $key => $value) {

					$dppTotal = $value->sales_order_detail_result;

					// $dppTotalRnd = round($value->sales_order_detail_result_large + $value->sales_order_detail_result_medium + $value->sales_order_detail_result_small, -2);
					$ppnTotal       = $value->sales_order_detail_ppn_total;
					$tax_percentage = $value->ppn_amount;

					$price_large    = $value->sales_order_detail_unit_price;
					if($value->sales_order_detail_ppn_status == 2){
						$price_large   = $value->sales_order_detail_unit_price + ($value->sales_order_detail_unit_price * ($tax_percentage/100));
					}
					$result_large  = (round($price_large) * $value->sales_order_detail_unit_quantity);


					$response[$k]['detail'][$key] = array(	
						'item_name'       => $value->sales_order_detail_item_name,
						'unit_large'      => $value->sales_order_detail_unit,
						'quantity_large'  => to_decimal($value->sales_order_detail_unit_quantity),
						'price_large'     => number_format($price_large),
						'result_large'    => number_format($result_large),
						'dppTotal'        => number_format(round($np += ($value->sales_order_detail_result), -2)),
						'dppTotalppn'     => number_format((round($a += $value->sales_order_detail_total, -2)/1.1)),
						'ppnTotal'        => number_format((round($b += $value->sales_order_detail_total, -2)/1.1)*10/100),
						'ppndppTotal'     => number_format(round($d += ($dppTotal + $ppnTotal), -2)),
						'grandTotal'      => number_format(round($c += ($value->sales_order_detail_total), -2))
					);

				}
				$no++;
			}
		}
		

		// echo json_encode($response);
		// die();
		$ppn_not_exist = false;
		$nonppn_not_exist = false;
		$special_not_exist = false;
		error_reporting(E_ALL ^ E_NOTICE);
		if (($response[2]['detail']) == undefined or count($response[2]['detail']) == 0) {
			$ppn_not_exist = true;
		}
		
		if (($response[1]['detail']) == undefined or count($response[1]['detail']) == 0) {
			$nonppn_not_exist = true;
		}

		if (($response[0]['detail']) == undefined or count($response[0]['detail']) == 0) {
			$special_not_exist = true;
		}
		
		$data['content_title']     = 'Print Penjualan';
		$data['header']            = $header;
		$data['config_receipt1']   = $config_receipt1;
		$data['config_receipt2']   = $config_receipt2;
		$data['config_receipt3']   = $config_receipt3;
		$data['customer_name']     = $customer_name;
		$data['customer_nik']      = $customer_ktp;
		$data['customer_npwp']     = $customer_npwp;
		$data['printed_date']      = $printed_date;
		$data['maintenance_data']  = $get_data;
		$data['get_data']          = $response;
		$data['ppn_not_exist']     = $ppn_not_exist;
		$data['nonppn_not_exist']  = $nonppn_not_exist;
		$data['special_not_exist'] = $special_not_exist;

		$this->twiggy_display('adm/sales_orders/invoice', $data);
	}

	public function stored_invoice($id)
	{	
		$detail_data = [];
		
		$where    = array('sales_order_detail_header_id' => $id);
		$order    = array('item_name' => 'asc');
		$get_data = $this->Sales_orders_model->salesorder_detail($where, 'b.item_name asc')->result();

		$where_header   = array('sales_order_header_id' => $id);
		$header_data    = $this->Sales_orders_model->salesorder_header($where_header)->row_array();
		$tax_percentage = ($header_data['ppn_amount']);

		foreach($get_data as $get_row)
		{

			if($get_row->sales_order_detail_large_unit_quantity > 0){
				$ppn_total_large = 0;
				$total_large     = $get_row->sales_order_detail_total;
				
				if($get_row->sales_order_detail_ppn_status == "2"){
					$ppn_total_large = $get_row->sales_order_detail_result_large * ($tax_percentage/100);
					$total_large     = $get_row->sales_order_detail_result_large + $ppn_total_large;
				}

				$detail_data[] = [
					'sales_order_detail_header_id'     => $get_row->sales_order_detail_header_id,
					'sales_order_detail_item_id'       => $get_row->sales_order_detail_item_id,
					'sales_order_detail_item_name'     => $get_row->sales_order_detail_item_name,
					'sales_order_detail_unit'          => $get_row->sales_order_detail_large_unit,
					'sales_order_detail_unit_quantity' => $get_row->sales_order_detail_large_unit_quantity,
					'sales_order_detail_unit_price'    => $get_row->sales_order_detail_large_unit_price,
					'sales_order_detail_result'        => $get_row->sales_order_detail_result_large,
					'sales_order_detail_ppn_status'    => $get_row->sales_order_detail_ppn_status,
					'sales_order_detail_ppn_total'     => $ppn_total_large,
					'sales_order_detail_total'         => $total_large,
				];
			}
			if($get_row->sales_order_detail_medium_unit_quantity > 0){

				$ppn_total_medium = 0;
				$total_medium     = $get_row->sales_order_detail_total;
				
				if($get_row->sales_order_detail_ppn_status == "2"){
					$ppn_total_medium = $get_row->sales_order_detail_result_medium * ($tax_percentage/100);
					$total_medium     = $get_row->sales_order_detail_result_medium + $ppn_total_medium;
				}

				$detail_data[] = [
					'sales_order_detail_header_id'     => $get_row->sales_order_detail_header_id,
					'sales_order_detail_item_id'       => $get_row->sales_order_detail_item_id,
					'sales_order_detail_item_name'     => $get_row->sales_order_detail_item_name,
					'sales_order_detail_unit'          => $get_row->sales_order_detail_medium_unit,
					'sales_order_detail_unit_quantity' => $get_row->sales_order_detail_medium_unit_quantity,
					'sales_order_detail_unit_price'    => $get_row->sales_order_detail_medium_unit_price,
					'sales_order_detail_result'        => $get_row->sales_order_detail_result_medium,
					'sales_order_detail_ppn_status'    => $get_row->sales_order_detail_ppn_status,
					'sales_order_detail_ppn_total'     => $ppn_total_medium,
					'sales_order_detail_total'         => $total_medium,
				];
			}

			if($get_row->sales_order_detail_small_unit_quantity > 0){

				$ppn_total_small = 0;
				$total_small     = $get_row->sales_order_detail_total;
				
				if($get_row->sales_order_detail_ppn_status == "2"){
					$ppn_total_small = $get_row->sales_order_detail_result_small * ($tax_percentage/100);
					$total_small     = $get_row->sales_order_detail_result_small + $ppn_total_small;
				}

				$detail_data[] = [
					'sales_order_detail_header_id'     => $get_row->sales_order_detail_header_id,
					'sales_order_detail_item_id'       => $get_row->sales_order_detail_item_id,
					'sales_order_detail_item_name'     => $get_row->sales_order_detail_item_name,
					'sales_order_detail_unit'          => $get_row->sales_order_detail_small_unit,
					'sales_order_detail_unit_quantity' => $get_row->sales_order_detail_small_unit_quantity,
					'sales_order_detail_unit_price'    => $get_row->sales_order_detail_small_unit_price,
					'sales_order_detail_result'        => $get_row->sales_order_detail_result_small,
					'sales_order_detail_ppn_status'    => $get_row->sales_order_detail_ppn_status,
					'sales_order_detail_ppn_total'     => $ppn_total_small,
					'sales_order_detail_total'         => $total_small,
				];
			}
			

		}

		$save = $this->Sales_orders_model->save_stored_invoice($detail_data, true);
			
		$status = false;
		if($save){
			$status = true;
		}

		return $status;
	}

	public function print_out2($id)
	{	
		date_default_timezone_set('Asia/Jakarta');
		$where_header = array('sales_order_header_id' => $id);
		$where_config1 = array('ppn_status' => '1', 'is_active' => '1');
		$where_config2 = array('ppn_status' => '2', 'is_active' => '1');
		$where_config3 = array('ppn_status' => '3', 'is_active' => '1');
		
		$header          = $this->Sales_orders_model->salesorder_header($where_header)->row_array();
		$config_receipt1 = $this->Configuration_model->get_data_invoice($where_config1)->row_array();
		$config_receipt2 = $this->Configuration_model->get_data_invoice($where_config2)->row_array();
		$config_receipt3 = $this->Configuration_model->get_data_invoice($where_config3)->row_array();
		// $user_handle = $this->Users_model->get_data_advance($header['sales_order_header_user_id'])->row()->fullname;
		$customer_name = $header['customer_name'];
		$customer_ktp  = $header['customer_ktp'];
		$customer_npwp = $header['customer_npwp'];
		$printed_date = date('H:i:s');

		$where_nonppn = array('sales_order_detail_header_id' => $id, 'sales_order_detail_ppn_status' => 1);
		$where_ppn    = array('sales_order_detail_header_id' => $id, 'sales_order_detail_ppn_status' => 2);
		$where_khusus = array('sales_order_detail_header_id' => $id, 'sales_order_detail_ppn_status' => 3);

		$order = 'large_unit_pr asc, medium_unit_pr asc, small_unit_pr asc';

		$getdata_nonppn = $this->Sales_orders_model->salesorder_detail($where_nonppn, $order)->result();
		$getdata_ppn    = $this->Sales_orders_model->salesorder_detail($where_ppn, $order)->result();
		$getdata_khusus = $this->Sales_orders_model->salesorder_detail($where_khusus, $order)->result();
		
		if($getdata_nonppn)
		{
			$no = 1;
			$a = 0;
			$b = 0;
			$c = 0;
			$d = 0;

			foreach($getdata_nonppn as $get_row)
			{
				$data_nonppn[] = array(
					'number'          => $no,
					'item_name'       => $get_row->sales_order_detail_item_name,
					'unit_large'      => $get_row->sales_order_detail_large_unit,
					'quantity_large'  => to_decimal($get_row->sales_order_detail_large_unit_quantity),
					'price_large'     => number_format($get_row->sales_order_detail_large_unit_price),
					'result_large'    => number_format($get_row->sales_order_detail_result_large),
					'unit_medium'     => $get_row->sales_order_detail_medium_unit,
					'quantity_medium' => to_decimal($get_row->sales_order_detail_medium_unit_quantity),
					'price_medium'    => number_format($get_row->sales_order_detail_medium_unit_price),
					'result_medium'   => number_format($get_row->sales_order_detail_result_medium),
					'unit_small'      => $get_row->sales_order_detail_small_unit,
					'quantity_small'  => to_decimal($get_row->sales_order_detail_small_unit_quantity),
					'price_small'     => number_format($get_row->sales_order_detail_small_unit_price),
					'result_small'    => number_format($get_row->sales_order_detail_result_small),
					'dppTotal'        => number_format($a += ($get_row->sales_order_detail_result_large + $get_row->sales_order_detail_result_medium + $get_row->sales_order_detail_result_small)),
					'ppnTotal'        => number_format($b += ($get_row->sales_order_detail_ppn_total)),
					'ppndppTotal'     => number_format($d += ($get_row->sales_order_detail_result_large + $get_row->sales_order_detail_result_medium + $get_row->sales_order_detail_result_small + $get_row->sales_order_detail_ppn_total)),
					'grandTotal'      => number_format($c += ($get_row->sales_order_detail_total))
				);
				$no++;
			}
		}

		if($getdata_ppn)
		{
			$no = 1;
			$a = 0;
			$b = 0;
			$c = 0;
			$d = 0;

			foreach($getdata_ppn as $get_row)
			{
				$data_ppn[] = array(
					'number'          => $no,
					'item_name'       => $get_row->sales_order_detail_item_name,
					'unit_large'      => $get_row->sales_order_detail_large_unit,
					'quantity_large'  => to_decimal($get_row->sales_order_detail_large_unit_quantity),
					'price_large'     => number_format($get_row->sales_order_detail_large_unit_price),
					'result_large'    => number_format($get_row->sales_order_detail_result_large),
					'unit_medium'     => $get_row->sales_order_detail_medium_unit,
					'quantity_medium' => to_decimal($get_row->sales_order_detail_medium_unit_quantity),
					'price_medium'    => number_format($get_row->sales_order_detail_medium_unit_price),
					'result_medium'   => number_format($get_row->sales_order_detail_result_medium),
					'unit_small'      => $get_row->sales_order_detail_small_unit,
					'quantity_small'  => to_decimal($get_row->sales_order_detail_small_unit_quantity),
					'price_small'     => number_format($get_row->sales_order_detail_small_unit_price),
					'result_small'    => number_format($get_row->sales_order_detail_result_small),
					'dppTotal'        => number_format($a += ($get_row->sales_order_detail_result_large + $get_row->sales_order_detail_result_medium + $get_row->sales_order_detail_result_small)),
					'ppnTotal'        => number_format($b += ($get_row->sales_order_detail_ppn_total)),
					'ppndppTotal'     => number_format($d += ($get_row->sales_order_detail_result_large + $get_row->sales_order_detail_result_medium + $get_row->sales_order_detail_result_small + $get_row->sales_order_detail_ppn_total)),
					'grandTotal'      => number_format($c += ($get_row->sales_order_detail_total))
				);
				$no++;
			}
		}

		if($getdata_khusus)
		{
			$no = 1;
			$a = 0;
			$b = 0;
			$c = 0;
			$d = 0;

			foreach($getdata_khusus as $get_row)
			{
				$data_khusus[] = array(
					'number'          => $no,
					'item_name'       => $get_row->sales_order_detail_item_name,
					'unit_large'      => $get_row->sales_order_detail_large_unit,
					'quantity_large'  => to_decimal($get_row->sales_order_detail_large_unit_quantity),
					'price_large'     => number_format($get_row->sales_order_detail_large_unit_price),
					'result_large'    => number_format($get_row->sales_order_detail_result_large),
					'unit_medium'     => $get_row->sales_order_detail_medium_unit,
					'quantity_medium' => to_decimal($get_row->sales_order_detail_medium_unit_quantity),
					'price_medium'    => number_format($get_row->sales_order_detail_medium_unit_price),
					'result_medium'   => number_format($get_row->sales_order_detail_result_medium),
					'unit_small'      => $get_row->sales_order_detail_small_unit,
					'quantity_small'  => to_decimal($get_row->sales_order_detail_small_unit_quantity),
					'price_small'     => number_format($get_row->sales_order_detail_small_unit_price),
					'result_small'    => number_format($get_row->sales_order_detail_result_small),
					'dppTotal'        => number_format($a += ($get_row->sales_order_detail_result_large + $get_row->sales_order_detail_result_medium + $get_row->sales_order_detail_result_small)),
					'ppnTotal'        => number_format($b += ($get_row->sales_order_detail_ppn_total)),
					'ppndppTotal'     => number_format($d += ($get_row->sales_order_detail_result_large + $get_row->sales_order_detail_result_medium + $get_row->sales_order_detail_result_small + $get_row->sales_order_detail_ppn_total)),
					'grandTotal'      => number_format($c += ($get_row->sales_order_detail_total))
				);
				$no++;
			}
		}
		
		
		$data['content_title']     = 'Print Penjualan';
		$data['header']            = $header;
		$data['config_receipt1']   = $config_receipt1;
		$data['config_receipt2']   = $config_receipt2;
		$data['config_receipt3']   = $config_receipt3;
		$data['customer_name']     = $customer_name;
		$data['customer_nik']      = $customer_ktp;
		$data['customer_npwp']     = $customer_npwp;
		$data['printed_date']      = $printed_date;
		// $data['maintenance_data']  = $get_data;
		// $data['data_nonppn']          = $data_nonppn;
		// $data['data_ppn']          = $data_ppn;
		$data['data_khusus']          = $data_khusus;
		// $data['ppn_not_exist']     = $ppn_not_exist;
		// $data['nonppn_not_exist']  = $nonppn_not_exist;
		// $data['special_not_exist'] = $special_not_exist;

		$this->twiggy_display('adm/sales_orders/receipt2', $data);
	}

	public function checkpoint($s_trx, $transaction_id, $transaction_date='', $customer_id='')
	{
		$where       = array('sales_order_detail_header_id' => $transaction_id);

		$data     = [];
		$data_req = [];
		$get_data = $this->Sales_orders_model->salesorder_detail($where)->result();
		$ttl_pts = 0;

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			
			foreach($get_data as $get_row)
			{
				$item_id = $get_row->sales_order_detail_item_id;
				$lg_qty  = to_decimal($get_row->sales_order_detail_large_unit_quantity);
				$lg_prc  = $get_row->sales_order_detail_total;

				$data[] = array(
					'id'                 => $get_row->sales_order_detail_item_id,
					'name'               => $get_row->sales_order_detail_item_name,
					'lg_unit'            => $get_row->sales_order_detail_large_unit,
					'lg_unit_qty'        => to_decimal($get_row->sales_order_detail_large_unit_quantity),
					'lg_unit_prc'        => number_format($get_row->sales_order_detail_total)
				);

				$where_requirements = array('ptsreq_detail_item_id' => $item_id);
				$where_period = '';
				if(isset($transaction_date) && $transaction_date != '')
				{
					$where_period   = change_format_date($transaction_date);
				}
				
				$get_data_requirements = $this->Ptsreqs_model->ptsreq_advance($where_requirements, $where_period)->result();
				foreach($get_data_requirements as $key => $get_row_requirements)
				{
					
					$get_header = $this->Ptsreqs_model->ptsreq_advance(array('ptsreq_detail_header_id' => $get_row_requirements->ptsreq_detail_header_id))->row();
					$calculate  = 0;
					if($get_row_requirements->ptsreq_detail_large_quantity > 0){
						$calculate  = ($lg_qty / to_decimal($get_row_requirements->ptsreq_detail_large_quantity));
					}else{
						$calculate  = ($lg_prc / $get_row_requirements->ptsreq_detail_large_unit_price);
					}

					$data_req[] = array(
						'id'             => $get_row_requirements->ptsreq_detail_id,
						'header_id'      => $get_row_requirements->ptsreq_detail_header_id,
						'item_id'        => $get_row_requirements->ptsreq_detail_item_id,
						'item_name'      => $get_row_requirements->ptsreq_detail_item_name,
						'lg_unit'        => $get_row_requirements->ptsreq_detail_large_unit,
						'lg_unit_qty'    => to_decimal($get_row_requirements->ptsreq_detail_large_quantity),
						'lg_unit_prc'    => number_format($get_row_requirements->ptsreq_detail_large_unit_price),
						'multiples'      => floor($calculate),
						'point_earned'   => floor($calculate * $get_header->ptsreq_header_total)
					);

					$header_id = $get_row_requirements->ptsreq_detail_header_id;
					$array_row = array_count_values(array_column($data_req, 'header_id'))[$header_id];
					$data_row  = count($this->Ptsreqs_model->ptsreq_advance(array('ptsreq_detail_header_id' => $get_row_requirements->ptsreq_detail_header_id))->result());

					if($array_row == $data_row){
						$filtered = array_filter($data_req, function($v) use ($header_id) { 
							return $v['header_id'] == $header_id; 
						});

						$get_multiples  = (min(array_column( $filtered, 'multiples' )));
						$get_pts        = floor($get_multiples) * $get_header->ptsreq_header_total;
						$ttl_pts       += $get_pts;
					}
					
				}
				
			}
		}

		// echo json_encode($data);
		// die();
		if($s_trx == 'new'){

			$where       = array('log_point_customer_id' => $customer_id);
			$log_data    = $this->Log_points_model->get_data_last($where)->row_array();
			$point_total = 0;
			$last_point_total  = 0;

			if(!empty($log_data)){
				$last_point_total = $log_data['log_point_total'];
			}

			$point_total = ($last_point_total + $ttl_pts);
			$header_data = [
				'log_point_type'           => 'SO',
				'log_point_transaction_id' => $transaction_id,
				'log_point_customer_id'    => $customer_id,
				'log_point_earned'         => $ttl_pts,
				'log_point_total'          => $point_total,
			];

			$save_header = $this->Log_points_model->save($header_data);

		}

		if($s_trx == 'update'){
			
			$where_1          = array('log_point_type' => 'SO', 'log_point_transaction_id' => $transaction_id, 'log_point_customer_id' => $customer_id);
			$log_point_id     = $this->Log_points_model->get_data($where_1)->row()->log_point_id;
			$where_2          = array('log_point_customer_id' => $customer_id, 'log_point_id <' => $log_point_id);
			$log_data_before  = $this->Log_points_model->get_data_last($where_2)->row_array();
			$point_total      = 0;
			$last_point_total = 0;

			if(!empty($log_data_before)){
				$last_point_total = $log_data_before['log_point_total'];
			}

			$point_total = ($last_point_total + $ttl_pts);
			$header_data = [
				'log_point_type'           => 'SO',
				'log_point_transaction_id' => $transaction_id,
				'log_point_customer_id'    => $customer_id,
				'log_point_earned'         => $ttl_pts,
				'log_point_total'          => $point_total,
			];
			
			$update_item  = $this->Log_points_model->update($where_1, $header_data);

			if($update_item){
				$where_3 = array('log_point_customer_id' => $customer_id, 'log_point_id >' => $log_point_id);
				$get_data_all_logs_by_customer = $this->Log_points_model->get_data($where_3)->result();

				if($get_data_all_logs_by_customer){
					foreach ($get_data_all_logs_by_customer as $row) {

						$where_3              = array('log_point_customer_id' => $row->log_point_customer_id, 'log_point_id <' => $row->log_point_id);
						$log_data_off         = $this->Log_points_model->get_data_last($where_3)->row_array();
						$point_total_off      = 0;
						$last_point_total_off = 0;

						if(!empty($log_data_off)){
							$last_point_total_off = $log_data_off['log_point_total'];
						}

						$point_total_off = ($last_point_total_off + $row->log_point_earned);
						$update_after = array(
							'log_point_total'  => $point_total_off,
						);

						$where_after = array(
							'log_point_id' => $row->log_point_id
						);

						$save_header = $this->Log_points_model->update($where_after, $update_after);

					}
				}else{
					return true;
				}
			}else{
				$save_header = false;
			}

		}

		if($s_trx == 'delete'){
			$save_header = false;
			$where = array('log_point_type' => 'SO', 'log_point_transaction_id' => $transaction_id);
			$get_data_log = $this->Log_points_model->get_data($where)->result();

			foreach ($get_data_log as $row_list) {
				
				$where_after = array('log_point_customer_id' => $row_list->log_point_customer_id, 'log_point_id >' => $row_list->log_point_id);
				$get_after   = $this->Log_points_model->get_data($where_after)->result();

				if($get_after){

					foreach ($get_after as $row_list_detail) {
						
						$where_delete = array('log_point_id' => $row_list->log_point_id);
						$delete  = $this->Log_points_model->delete($where_delete);

						$where_this   = array('log_point_id' => $row_list_detail->log_point_id, 'log_point_customer_id' => $row_list_detail->log_point_customer_id);
						$log_point_id = $this->Log_points_model->get_data($where_this)->row()->log_point_id;
						
						$where_3              = array('log_point_customer_id' => $row_list_detail->log_point_customer_id, 'log_point_id <' => $log_point_id);
						$log_data_off         = $this->Log_points_model->get_data_last($where_3)->row_array();
						$point_total_off      = 0;
						$last_point_total_off = 0;

						if(!empty($log_data_off)){
							$last_point_total_off = $log_data_off['log_point_total'];
						}

						$point_total_off = ($last_point_total_off + $row_list_detail->log_point_earned);
						$update_after = array(
							'log_point_total'  => $point_total_off,
						);

						$where_after = array(
							'log_point_id' => $row_list_detail->log_point_id
						);

						$save_header = $this->Log_points_model->update($where_after, $update_after);
					}
					
				}else{
					$where_delete = array('log_point_id' => $row_list->log_point_id);
					$save_header  = $this->Log_points_model->delete($where_delete);
				}
			}

		}
		
		if($save_header){
			return true;
		}else{
			return false;
		}
	}


	public function cetak_struk() {
        // me-load library escpos
        $this->load->library('escpos');
 
        // membuat connector printer ke shared printer bernama "printer_a" (yang telah disetting sebelumnya)
        $connector = new Escpos\PrintConnectors\NetworkPrintConnector("smb://192.168.1.10/SFR2");
 
        // membuat objek $printer agar dapat di lakukan fungsinya
        $printer = new Escpos\Printer($connector);
 
 
        /* ---------------------------------------------------------
         * Teks biasa | text()
         */
        $printer->initialize();
        $printer->text("Ini teks biasa \n");
        $printer->text("\n");
 
        /* ---------------------------------------------------------
         * Select print mode | selectPrintMode()
         */
        // Printer::MODE_FONT_A
        $printer->initialize();
        $printer->selectPrintMode(Escpos\Printer::MODE_FONT_A);
        $printer->text("teks dengan MODE_FONT_A \n");
        $printer->text("\n");
 
        // Printer::MODE_FONT_B
        $printer->initialize();
        $printer->selectPrintMode(Escpos\Printer::MODE_FONT_B);
        $printer->text("teks dengan MODE_FONT_B \n");
        $printer->text("\n");
 
        // Printer::MODE_EMPHASIZED
        $printer->initialize();
        $printer->selectPrintMode(Escpos\Printer::MODE_EMPHASIZED);
        $printer->text("teks dengan MODE_EMPHASIZED \n");
        $printer->text("\n");
 
        // Printer::MODE_DOUBLE_HEIGHT
        $printer->initialize();
        $printer->selectPrintMode(Escpos\Printer::MODE_DOUBLE_HEIGHT);
        $printer->text("teks dengan MODE_DOUBLE_HEIGHT \n");
        $printer->text("\n");
 
        // Printer::MODE_DOUBLE_WIDTH
        $printer->initialize();
        $printer->selectPrintMode(Escpos\Printer::MODE_DOUBLE_WIDTH);
        $printer->text("teks dengan MODE_DOUBLE_WIDTH \n");
        $printer->text("\n");
 
        // Printer::MODE_UNDERLINE
        $printer->initialize();
        $printer->selectPrintMode(Escpos\Printer::MODE_UNDERLINE);
        $printer->text("teks dengan MODE_UNDERLINE \n");
        $printer->text("\n");
 
 
        /* ---------------------------------------------------------
         * Teks dengan garis bawah  | setUnderline()
         */
        $printer->initialize();
        $printer->setUnderline(Escpos\Printer::UNDERLINE_DOUBLE);
        $printer->text("Ini teks dengan garis bawah \n");
        $printer->text("\n");
 
        /* ---------------------------------------------------------
         * Rata kiri, tengah, dan kanan (JUSTIFICATION) | setJustification()
         */
        // Teks rata kiri JUSTIFY_LEFT
        $printer->initialize();
        $printer->setJustification(Escpos\Printer::JUSTIFY_LEFT);
        $printer->text("Ini teks rata kiri \n");
        $printer->text("\n");
 
        // Teks rata tengah JUSTIFY_CENTER
        $printer->initialize();
        $printer->setJustification(Escpos\Printer::JUSTIFY_CENTER);
        $printer->text("Ini teks rata tengah \n");
        $printer->text("\n");
 
        // Teks rata kanan JUSTIFY_RIGHT
        $printer->initialize();
        $printer->setJustification(Escpos\Printer::JUSTIFY_RIGHT);
        $printer->text("Ini teks rata kanan \n");
        $printer->text("\n");
 
 
        /* ---------------------------------------------------------
         * Font A, B dan C | setFont()
         */
        // Teks dengan font A
        $printer->initialize();
        $printer->setFont(Escpos\Printer::FONT_A);
        $printer->text("Ini teks dengan font A \n");
        $printer->text("\n");
 
        // Teks dengan font B
        $printer->initialize();
        $printer->setFont(Escpos\Printer::FONT_B);
        $printer->text("Ini teks dengan font B \n");
        $printer->text("\n");
 
        // Teks dengan font C
        $printer->initialize();
        $printer->setFont(Escpos\Printer::FONT_C);
        $printer->text("Ini teks dengan font C \n");
        $printer->text("\n");
 
        /* ---------------------------------------------------------
         * Jarak perbaris 40 (linespace) | setLineSpacing()
         */
        $printer->initialize();
        $printer->setLineSpacing(40);
        $printer->text("Ini paragraf dengan \nline spacing sebesar 40 \ndi printer dotmatrix \n");
        $printer->text("\n");
 
        /* ---------------------------------------------------------
         * Jarak dari kiri (Margin Left) | setPrintLeftMargin()
         */
        $printer->initialize();
        $printer->setPrintLeftMargin(10);
        $printer->text("Ini teks berjarak 10 dari kiri (Margin left) \n");
        $printer->text("\n");
 
        /* ---------------------------------------------------------
         * membalik warna teks (background menjadi hitam) | setReverseColors()
         */
        $printer->initialize();
        $printer->setReverseColors(TRUE);
        $printer->text("Warna Teks ini terbalik \n");
        $printer->text("\n");
 
 
        /* ---------------------------------------------------------
         * Menyelesaikan printer
         */
        $printer->feed(4); // mencetak 2 baris kosong, agar kertas terangkat ke atas
        $printer->close();
    }

}

?>
